% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_func.R
\name{krig}
\alias{krig}
\title{Internal function used to perform spatial prediction in R using a stanfit object from ssnbayes()}
\usage{
krig(
  object = object,
  mat_all_preds = mat_all_preds,
  nsamples = 10,
  start = 1,
  chunk_size = 50,
  obs_data = obs_data,
  pred_data = pred_data,
  net = net,
  seed = seed
)
}
\arguments{
\item{object}{A stanfit object returned from ssnbayes}

\item{mat_all_preds}{A list with the distance/weights matrices}

\item{nsamples}{The number of samples to draw from the posterior distributions. (nsamples <= iter)}

\item{start}{(optional) The starting location id}

\item{chunk_size}{(optional) the number of locID to make prediction from}

\item{obs_data}{The observed data frame}

\item{pred_data}{The predicted data frame}

\item{net}{(optional) Network from the SSN object}

\item{seed}{(optional) A seed for reproducibility}
}
\value{
A data frame
}
\description{
Use predict.ssnbayes() instead.
It will take an observed and a prediction data frame.
It requires the same number of observation/locations per day.
It requires location id (locID) and points id (pid).
The locID are unique for each site.
The pid is unique for each observation.
Missing values are allowed in the response but not in the covariates.
}
\author{
Edgar Santos-Fernandez
}
