% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PALM.R
\name{PALM}
\alias{PALM}
\title{Population Allele Locating Mapmaker}
\usage{
PALM(
  variant,
  variantType,
  filename,
  mask = FALSE,
  color = TRUE,
  filterMigrant = TRUE,
  mapScale = TRUE,
  direct = getwd(),
  AFND = TRUE,
  generateLowFreq = TRUE,
  resolution = 500
)
}
\arguments{
\item{variant}{An allele or an amino acid motif in the following format: Locus*##$~##$~##$, where ## identifies a peptide position, and $ identifies an amino acid residue. Motifs can include any number of amino acids. Haplotypes must contain alleles that follow the aforementioned format, and may be delimited by "~" or "-".}

\item{variantType}{Specifies whether the variant is an allele, motif, or haplotype.}

\item{filename}{The full file path of the user specified dataset if the user wishes to use their own file, or the pre-bundled Solberg dataset or mock haplotype dataset. User provided datasets must be a .dat, .txt, or.csv file, and must conform to the structure and format of the datasets bundled with the package. Allele and motif datasets should follow the Solberg dataset format, and haplotype datasets should follow the SSHAARP haplotype mock data format.}

\item{mask}{A logical parameter that determines if areas with little to no population coverage should be masked. The default value is set to FALSE.}

\item{color}{A logical parameter that identifies if the heat maps should be made in color (TRUE) or gray scale (FALSE). The default value is TRUE.}

\item{filterMigrant}{A logical parameter that determines if admixed populations (OTH) and migrant populations (i.e. any complexities with the 'mig') should be excluded from the dataset. The default value is TRUE.}

\item{mapScale}{A logical parameter that determines if the max frequency value of the map scale should be 1 (FALSE), or if it should represent the maximum frequency of the chosen motif, allele, or haplotype (TRUE). The default value is TRUE.}

\item{direct}{The directory into which the map produced is written. The default directory is the user's working directory.}

\item{AFND}{A logical parameter that determines whether the user specified dataset is data from AFND. This parameter is only relevant if haplotype maps are being made. Default is TRUE.}

\item{generateLowFreq}{A logical parameter that determines whether maps should be generated for a variant if the maximum frequency for the variant is low frequency. Low frequency populations are defined as those with a frequency of 0.000, indicating three zeros after the decimal point.}

\item{resolution}{An integer for raster resolution in dpi for the final map output. It is not recommended to go below 400. Default is set to 500.}
}
\value{
The specified motif and the directory into which the heat map was written are returned in an invisible character vector. Otherwise, a warning message is returned.
}
\description{
Produces a frequency heatmap for a specified allele, amino-acid motif, or haplotype based on the allele frequency data in the Solberg dataset.
}
\note{
IMGT protein alignments will be generated for the locus of the specified variant the first time PALM is executed for a given locus. The alignments will be saved to the temp directory and referenced by PALM. PALM checks if the locus specific alignment is present in the temp directory; if it is not, a protein alignment object will be built for the locus. Restarting the R session will remove existing alignments.

The produced frequency heatmap is generated by using the Generic Mapping Tools (GMT) R Package, which is an interface between R and the GMT map making software.

The Solberg dataset is the tab-delimited ‘1-locus-alleles.dat’ text file in the results.zip archive at http://pypop.org/popdata/.

The Solberg dataset is also prepackaged into SSHAARP as 'solberg_dataset'.

A mock haplotype dataset modeled after the AFND network's haplotype dataset structure is available for usage under "mock_haplotype_dataset".

While the map legend identifies the highest frequency value, values in this range may not be represented on the map due to frequency averaging over neighboring populations.
}
\examples{
#Example to produce a motif color map where migrant populations are filtered out, mask is off
\dontrun{PALM("DRB1*26F~28E~30Y",
variantType="motif",
mask = FALSE,
filterMigrant=TRUE,
filename = SSHAARP::solberg_dataset)}

#Example to produce an allele greyscale map where migrant populations are not filtered, mask is on
\dontrun{PALM("DRB1*01:01",
variantType="allele",
mask = TRUE, color=FALSE,
filterMigrant=FALSE,
filename = SSHAARP::solberg_dataset)}

#Example to produce a color allele map with mapScale T and the allele has more than 2 fields
\dontrun{PALM("DRB1*01:01:01",
variantType="allele",
filterMigrant=FALSE,
mapScale=TRUE,
filename = SSHAARP::solberg_dataset)}

#Example to produce a color haplotype map with default parameters with the mock haplotype dataset
\dontrun{PALM("DRB1*01:01~A*01:01",
variantType = "haplotype",
filename = SSHAARP::mock_haplotype_dataset)}

}
\references{
Solberg et.al. (2008) <doi: 10.1016/j.humimm.2008.05.001>
}
