% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_metrics.R
\name{visualize_metrics}
\alias{visualize_metrics}
\title{Visualize summarized metrics for reference data and synthetic data}
\usage{
visualize_metrics(
  simsrt,
  metric_type = c("all", "genewise", "locwise", "GeneMean", "GeneVar", "GeneCV",
    "GeneZeroProp", "LocZeroProp", "LocLibSize"),
  colorpalette = "Set3",
  axistextsize = 12
)
}
\arguments{
\item{simsrt}{A SRTsim object}

\item{metric_type}{Specification of metrics to be plotted. Default value is 'all', which will plot all six metrics: including four gene-wise metrics and two location-wise metrics. "genewise" will produce violin plots for all four gene-wise metrics; "locwise" will produce violin plots for all two location-wise metrics; "GeneMean", "GeneVar", "GeneCV", "GeneZeroProp", "LocZeroProp", and "LocLibSize" will produce single violin plot for the corresponding metric.}

\item{colorpalette}{Specification of color palette to be passed to \code{palette} in the \code{scale_fill_brewer}. Default is "Set3"}

\item{axistextsize}{Specification of axis font size. Default is 12.}
}
\value{
Returns a list of ggplots
}
\description{
Visualize summarized metrics for reference data and synthetic data
}
\examples{


## Create a simSRT object
toySRT  <- createSRT(count_in=toyData$toyCount,loc_in = toyData$toyInfo)
set.seed(1)

## Estimate model parameters for data generation
toySRT <- srtsim_fit(toySRT,sim_schem="tissue")

## Generate synthetic data with estimated parameters
toySRT <- srtsim_count(toySRT)

## Compute metrics 
toySRT   <- compareSRT(toySRT)

## Visualize Metrics
visualize_metrics(toySRT)
}
