% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funKerasMnist.R
\name{getMnistData}
\alias{getMnistData}
\title{getMnistData}
\usage{
getMnistData(kerasConf)
}
\arguments{
\item{kerasConf}{List of additional parameters passed to keras as described
in \code{\link{getKerasConf}}. Default: \code{NULL}.}
}
\value{
list with training and test data, i.e.,
\code{list(x_train, x_test, y_train, y_test)}.
}
\description{
Based on the setting \code{kerasConf$encoding} either one-hot encoded data or
tensor-shaped data are returned.The labels are converted to binary class matrices using
the function \code{\link[keras]{to_categorical}}.
}
\examples{
\donttest{
### These examples require an activated Python environment as described in
### Bartz-Beielstein, T., Rehbach, F., Sen, A., and Zaefferer, M.:
### Surrogate Model Based Hyperparameter Tuning for Deep Learning with SPOT,
### June 2021. http://arxiv.org/abs/2105.14625.
PYTHON_RETICULATE <- FALSE
if(PYTHON_RETICULATE){

library("SPOTMisc")
kerasConf <- getKerasConf()
kerasConf$encoding <- "oneHot" # default
mnist <- getMnistData(kerasConf)
# lots of zeros, but there are also some nonzero (greyscale) values, e.g.:
mnist$x_train[1,150:160]
str(mnist$x_train[1,])
# y-labels are one-hot encoded. The first entry represents "5"
mnist$y_train[1,]
##
kerasConf$encoding <- "tensor"
mnist <- getMnistData(kerasConf)
## 28x28:
str(mnist$x_train[1,,,])
mnist$y_train[1,]
}
}
}
\seealso{
\code{\link{getKerasConf}}

\code{\link{funKerasMnist}}
}
