% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funKerasMnist.R
\name{evalKerasMnist}
\alias{evalKerasMnist}
\title{evalKerasMnist}
\usage{
evalKerasMnist(x, kerasConf = getKerasConf(), data = getMnistData())
}
\arguments{
\item{x}{matrix of hyperparameter values to evaluate with the function.
Rows for points and columns for dimension.}

\item{kerasConf}{List of additional parameters passed to keras as described in \code{\link{getKerasConf}}.
Default: \code{kerasConf = getKerasConf()}.}

\item{data}{mnist data set. Default: \code{\link{getMnistData}}.}
}
\value{
list with function values (training, validation, and test loss/accuracy,
and keras model information)
}
\description{
Hyperparameter Tuning: Keras MNIST Classification Test Function.
}
\details{
Trains a simple deep NN on the MNIST dataset.
Standard Code from https://keras.rstudio.com/
Modified by T. Bartz-Beielstein (tbb@bartzundbartz.de)
}
\examples{
\donttest{
### These examples require an activated Python environment as described in
### Bartz-Beielstein, T., Rehbach, F., Sen, A., and Zaefferer, M.:
### Surrogate Model Based Hyperparameter Tuning for Deep Learning with SPOT,
### June 2021. http://arxiv.org/abs/2105.14625.
PYTHON_RETICULATE = FALSE
if(PYTHON_RETICULATE){

library("SPOTMisc")
kerasConf <- getKerasConf()
kerasConf$verbose <- 1
lower <- c(1e-6, 1e-6, 16,0.6, 1e-9, 10, 6,0.4,0.99,1,1e-8)
upper <- c(0.5, 0.5, 512, 1.5, 1e-2, 50, 10,0.999,0.999,10,6e-8)
types <- c("numeric",  "numeric",  "integer",  "numeric",  "numeric",
           "integer",  "integer",  "numeric",  "numeric",  "integer",
           "numeric")

x <- matrix(lower, 1,)
res <- evalKerasMnist(x, kerasConf)
str(res)
### The number of units for all layers can be listed as follows:
res$modelConf$config$layers[,2]$units
}
}
}
\seealso{
\code{\link{getKerasConf}}

\code{\link{funKerasMnist}}

\code{\link[keras]{fit}}
}
