% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimES.R
\name{optimES}
\alias{optimES}
\title{Evolution Strategy}
\usage{
optimES(x = NULL, fun, lower, upper, control = list(), ...)
}
\arguments{
\item{x}{optional start point, not used}

\item{fun}{objective function, which receives a matrix x and returns observations y}

\item{lower}{is a vector that defines the lower boundary of search space (this also defines the dimensionality of the problem)}

\item{upper}{is a vector that defines the upper boundary of search space (same length as lower)}

\item{control}{list of control parameters. The \code{control} list can contain the following settings:
\describe{
            \item{funEvals}{number of function evaluations, stopping criterion, default is \code{500}}
            \item{mue}{number of parents, default is \code{10}}
            \item{nu}{selection pressure. That means, number of offspring (lambda) is mue multiplied with nu. Default is \code{10}}
            \item{mutation}{string of mutation type, default is \code{1}}
            \item{sigmaInit}{initial sigma value (step size), default is \code{1.0}}
            \item{nSigma}{number of different sigmas, default is \code{1}}
            \item{tau0}{number, default is \code{0.0}. tau0 is the general multiplier.}
            \item{tau}{number, learning parameter for self adaption, i.e. the local multiplier for step sizes (for each dimension).default is \code{1.0}}
            \item{rho}{number of parents involved in the procreation of an offspring (mixing number), default is \code{"bi"}}
            \item{sel}{number of selected individuals, default is \code{1}}
            \item{stratReco}{Recombination operator for strategy variables. \code{1}: none. \code{2}: dominant/discrete (default). \code{3}: intermediate. \code{4}: variation of intermediate recombination. }
            \item{objReco}{Recombination operator for object variables. \code{1}: none. \code{2}: dominant/discrete (default). \code{3}: intermediate. \code{4}: variation of intermediate recombination. }
            \item{maxGen}{number of generations, stopping criterion, default is \code{Inf}}
            \item{seed}{number, random seed, default is \code{1}}
            \item{noise}{number, value of noise added to fitness values, default is \code{0.0}}
            \item{verbosity}{defines output verbosity of the ES, default is \code{0}}
            \item{plotResult}{boolean, specifies if results are plotted, default is \code{FALSE}}
            \item{logPlotResult}{boolean, defines if plot results should be logarithmic, default is \code{FALSE}}
            \item{sigmaRestart}{number, value of sigma on restart, default is \code{0.1}}
            \item{preScanMult}{initial population size is multiplied by this number for a pre-scan, default is \code{1}}
            \item{globalOpt}{termination criterion on reaching a desired optimum value, default is \code{rep(0,dimension)}}
}}

\item{...}{additional parameters to be passed on to \code{fun}}
}
\value{
list, with elements
\describe{
  \item{\code{x}}{NULL, currently not used}
  \item{\code{y}}{NULL, currently not used}
  \item{\code{xbest}}{best solution}
  \item{\code{ybest}}{best observation}
  \item{\code{count}}{number of evaluations of \code{fun}}
}
}
\description{
This is an implementation of an Evolution Strategy.
}
\examples{
cont <- list(funEvals=100)
optimES(fun=funSphere,lower=rep(0,2), upper=rep(1,2), control= cont) 

}
