% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectedImprovement.R
\name{expectedImprovement}
\alias{expectedImprovement}
\title{Expected Improvement}
\usage{
expectedImprovement(mean, sd, min)
}
\arguments{
\item{mean}{vector of predicted means of the candidate solutions.}

\item{sd}{vector of estimated uncertainties / standard deviations of the candidate solutions.}

\item{min}{minimal observed value.}
}
\value{
a vector with the negative logarithm of the expected improvement values, -log10(EI).
}
\description{
Compute the negative logarithm of the Expected Improvement of a 
set of candidate solutions.
Based on mean and standard deviation of a candidate solution,
this estimates the expectation of improvement. Improvement
considers the amount by which the best known value (best observed value)
is exceeded by the candidates.
}
\examples{
mean <- 1:10 #mean of the candidates
sd <- 10:1 #st. deviation of the candidates
min <- 5 #best known value
EI <- expectedImprovement(mean,sd,min)
EI
}
