% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimNLOPTR.R
\name{optimNLOPTR}
\alias{optimNLOPTR}
\title{optimNLOPTR. Minimization by NLOPT}
\usage{
optimNLOPTR(x = NULL, fun, lower, upper, control = list(), ...)
}
\arguments{
\item{x}{optional matrix of points to be included in the evaluation (only first row will be used)}

\item{fun}{objective function, which receives a matrix x and returns observations y}

\item{lower}{boundary of the search space}

\item{upper}{boundary of the search space}

\item{control}{named list, with the options for \code{nloptr}. These
will be passed to \code{nloptr} as arguments. In addition, the following
parameter can be used to set the function evaluation budget:
\describe{
  \item{\code{funEvals}}{Budget, number of function evaluations allowed. Default: 100.}
}}

\item{...}{passed to \code{fun}

Note that the arguments 
\code{x}, \code{fun}, \code{lower} and \code{upper} 
will be mapped to the corresponding arguments of \code{nloptr}: 
\code{x0}, \code{eval_f}, \code{lb} and \code{ub}.}
}
\value{
list, with elements
\describe{
  \item{\code{x}}{archive of evaluated solutions}
  \item{\code{y}}{archive of observations}
  \item{\code{xbest}}{best solution}
  \item{\code{ybest}}{best observation}
  \item{\code{count}}{number of evaluations of \code{fun}}
  \item{\code{message}}{success message}
}
}
\description{
#' This is a wrapper that employs the \code{nloptr} function from the package of the same name.
The \code{nloptr} function itself is an interface to the \code{nlopt} library, which contains a wide selection
of different optimization algorithms.
}
\examples{
\dontrun{
##simple example:
res <- optimNLOPTR(,fun = funSphere,lower = c(-10,-20),upper=c(20,8))
res
##with an inequality constraint:
contr <- list()  #control list
##specify constraint
contr$eval_g_ineq <- function(x) 1+x[1]-x[2]
res <- optimNLOPTR(,fun=funSphere,lower=c(-10,-20),upper=c(20,8),control=contr) 
res
}
}
