% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimLHD.R
\name{optimLHD}
\alias{optimLHD}
\title{Minimization by Latin Hypercube Sampling}
\usage{
optimLHD(x = NULL, fun, lower, upper, control = list(), ...)
}
\arguments{
\item{x}{optional matrix of points to be included in the evaluation}

\item{fun}{objective function, which receives a matrix x and returns observations y}

\item{lower}{boundary of the search space}

\item{upper}{boundary of the search space}

\item{control}{list of control parameters
\describe{
  \item{\code{funEvals}}{Budget, number of function evaluations allowed.}
  \item{\code{retries}}{Number of retries for design generation, used by \code{\link{designLHD}}}
}}

\item{...}{passed to \code{fun}}
}
\value{
list, with elements
\describe{
  \item{\code{x}}{archive of evaluated solutions}
  \item{\code{y}}{archive of observations}
  \item{\code{xbest}}{best solution}
  \item{\code{ybest}}{best observation}
  \item{\code{count}}{number of evaluations of \code{fun}}
  \item{\code{message}}{success message}
}
}
\description{
This uses Latin Hypercube Sampling (LHS) to optimize a specified target function.
A Latin Hypercube Design (LHD) is created with \code{\link{designLHD}}, then evaluated
by the objective function. All results are reported, including the best (minimal)
objective value, and corresponding design point.
}
\examples{
res <- optimLHD(,fun = funSphere,lower = c(-10,-20),upper=c(20,8))
res$ybest
}
