% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildKrigingDACE.R
\name{buildKrigingDACE}
\alias{buildKrigingDACE}
\title{Build DACE model}
\usage{
buildKrigingDACE(x, y, control = list())
}
\arguments{
\item{x}{design matrix (sample locations), rows for each sample, columns for each variable.}

\item{y}{vector of observations at \code{x}}

\item{control}{(list), with the options for the model building procedure:\cr
\code{startTheta} optional start value for theta optimization, default is \code{NULL}\cr
\code{algTheta}  algorithm used to find theta, default is \code{optimLBFGSB}.\cr
\code{budgetAlgTheta} budget for the above mentioned algorithm, default is \code{200}. The value will be multiplied with the length of the model parameter vector to be optimized.\cr
\code{nugget} Value for nugget. Default is -1, which means the nugget will be optimized during MLE. Else it can be fixed in a range between 0 and 1.
\code{regr} Regression function to be used: \code{\link{regpoly0}} (default), \code{\link{regpoly1}}, \code{\link{regpoly2}}. Can be a custom user function.\cr
\code{corr} Correlation function to be used: \code{\link{corrnoisykriging}} (default), \code{\link{corrkriging}}, \code{\link{corrnoisygauss}}, \code{\link{corrgauss}}, \code{\link{correxp}}, \code{\link{correxpg}}, \code{\link{corrlin}}, \code{\link{corrcubic}},\code{\link{corrspherical}},\code{\link{corrspline}}. Can also be user supplied (if in the right form).
\code{target} target values of the prediction, a vector of strings. Each string specifies a value to be predicted, e.g., "y" for mean, "s" for standard deviation, "ei" for expected improvement. See also \code{\link{predict.kriging}}.
This can also be changed after the model has been build, by manipulating the respective \code{object$target} value.}
}
\value{
returns an object of class \code{dace} with the following elements:
			\item{\code{model}}{A list, containing model parameters}
			\item{\code{like}}{Estimated likelihood value}
			\item{\code{theta}}{activity parameters theta (vector)}
			\item{\code{p}}{exponents p (vector)}
			\item{\code{lambda}}{nugget value (numeric)}
			\item{\code{nevals}}{ Number of iterations during MLE}
}
\description{
This Kriging meta model is based on DACE (Design and Analysis of Computer Experiments).
It allows to choose different regression and correlation models. The optimization of model parameters
is by default done with a bounded simplex method from the \code{nloptr} package.
}
\examples{
## Create design points
x <- cbind(runif(20)*15-5,runif(20)*15)
## Compute observations at design points 
y <- funSphere(x)
## Create model with default settings
fit <- buildKrigingDACE(x,y)
## Print model parameters
print(fit)
## Create with different regression and correlation functions
fit <- buildKrigingDACE(x,y,control=list(regr=regpoly2,corr=corrspline))
## Print model parameters
print(fit)

}
\references{
S.~Lophaven, H.~Nielsen, and J.~Sondergaard.
{DACE---A Matlab Kriging Toolbox}.
Technical Report IMM-REP-2002-12, Informatics and Mathematical
Modelling, Technical University of Denmark, Copenhagen, Denmark, 2002.
}
\seealso{
\code{\link{predict.dace}}
}
\author{
The authors of the original DACE Matlab toolbox \url{http://www2.imm.dtu.dk/projects/dace/} 
are Hans Bruun Nielsen \email{hbn@imm.dtu.dk}, Soren Nymand Lophaven and Jacob Sondergaard. \cr
Extension of the Matlab code by Tobias Wagner \email{wagner@isf.de}. \cr 
Porting and adaptation to R and further extensions by Martin Zaefferer \email{martin.zaefferer@fh-koeln.de}.
}
