SPCAvRP_ranking <- function( data            # a list of projected covariances P*Sigma*P (as generated by function 'project_covariance')
                           , rand_ind        # corresponding projections P (indices of non-zero elements)
                           , p               # original dimension
                           , A               # number of projections to be aggregated 
)
  # Output : ranking # an array of indices of variables ranked by their importance in maximising the variance
{ 
  N <- nrow(rand_ind)
  B <- floor(N/A)
  d <- ncol(rand_ind)
  
  # Selection of good projections
  v_hat_stars <- sapply(1:A, function(a){
    group_decomposition <- sapply(1:B, function(b){
      eig <- eigen(data[[B*(a-1)+b]], TRUE)
      return(list(eig$values[1],eig$vectors[,1]))})
    lambda_hat <- unlist(group_decomposition[1,])
    v_hat <- t(matrix(unlist(group_decomposition[2,]), nrow = B, ncol = d, byrow = TRUE))
    b_star <- which.max(lambda_hat)
    v_hat_star <- rep(0,p)
    v_hat_star[unlist(rand_ind[B*(a-1)+b_star,])] <- v_hat[,b_star]
    return(v_hat_star)
  }) 
  
  # Aggregation of good projections 
  ranking <- sort(rowSums(abs(v_hat_stars))/A, TRUE, index.return = TRUE)$ix
  
  return(ranking) 
}