% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_CoLChina.R
\name{download_CoLChina}
\alias{download_CoLChina}
\title{Download 'Catalogue of Life China': Annual Checklist}
\usage{
download_CoLChina(
  version = "2019",
  format = "zip",
  download = FALSE,
  dir = tempdir()
)
}
\arguments{
\item{version}{\code{integer} Release version of annual checklist,the default value is 2019.}

\item{format}{\code{character} Release version of format,the default value is zip.}

\item{download}{\code{logic} TRUE or FALSE,the default value is FALSE.}

\item{dir}{a non-empty character vector giving the directory name by user,the default value is dir = tempdir(),see [tempdir()] for details.}
}
\value{
URL
}
\description{
Organized by the Biodiversity Committee of Chinese Academy of Sciences, 'Catalogue of Life China' 2019 Annual Checklist edition has been compiled by 'Species 2000' China Node. It is funded by the Strategic Priority Research Program of the Chinese Academy of Sciences (Grant No. XDA19050202). It is released at Beijing on May, 2019.
}
\details{
Visit the website \url{http://sp2000.org.cn/download} for more details.
}
\examples{
\donttest{
dir <- tempdir()
download_CoLChina(version = "2019",format = "zip",download = TRUE, dir = dir)
}
}
\author{
Liuyong Ding
}
