% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{presidentielles2002}
\alias{presidentielles2002}
\title{2002 French presidential election data set}
\format{
\code{presidentielles2002} is a data frame of 106 rows (the French
administrative districts called "Départements") and 16 columns (the 
candidates).
}
\source{
The data are provided by the French ministry "Ministère de 
l'Intérieur". The original data can be downloaded at
\url{https://www.interieur.gouv.fr/Elections/Les-resultats/Presidentielles} 
(2002 élections and "Résultats par départements").
}
\description{
This data set provides the number of votes at the first round of
the 2002 French presidential election for each of the 16 candidates for 106
administrative districts called "Départements".
}
\examples{
data(presidentielles2002)
apply(presidentielles2002, 2, sum)
}
\references{
The 2002 French presidential election consisted of two rounds. 
The second round attracted a greater than usual amount of international 
attention because of far-right candidate Le Pen's unexpected victory over 
Socialist candidate Lionel Jospin. The event is known because, on the one 
hand, the number of candidates was unusually high (16) and, on the other 
hand, because the polls had failed to predict that Jean-Marie Le Pen would be
on the second round.

Further comments at
\url{https://en.wikipedia.org/wiki/2002_French_presidential_election}.
}
