% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilitiesGF.R
\name{int2poly}
\alias{int2poly}
\alias{poly2int}
\alias{gf_sum}
\alias{gf_prod}
\alias{gf_sum_list}
\alias{gf_matmult}
\title{Functions for Galois field calculations}
\usage{
int2poly(x, gf)

poly2int(poly, gf)

gf_sum(x, y, gf)

gf_prod(x, y, gf)

gf_sum_list(ll, gf, checks = TRUE)

gf_matmult(M1, M2, gf, checks = TRUE)
}
\arguments{
\item{x}{a vector of e elements in \code{0:(q-1)}}

\item{gf}{Galois field object with characteristic \code{q}}

\item{poly}{takes an e x n matrix of polygon rows or a
length n vector for a single polygon (e=1)}

\item{y}{a second vector of e elements in \code{0:(q-1)}}

\item{ll}{a list of integer vectors in \code{0:(q-1)}}

\item{checks}{logical: should checks be performed}

\item{M1}{matrix 1 with elements in \code{0:(q-1)}}

\item{M2}{matrix 2 with elements in \code{0:(q-1)}}
}
\value{
\code{int2poly} returns an e x n matrix or a length n vector (if x is scalar)

\code{poly2int} returns an e element vector of integers in \code{0:(q-1)}

\code{gf_sum} returns the sum (e elements in \code{0:(q-1)})

\code{gf_prod} returns the product (e elements in \code{0:(q-1)})

\code{gf_sum_list} returns the sum (an integer vector in \code{0:(q-1)})

\code{gf_matmult} returns the matrix product with elements from \code{0:(q-1)}
}
\description{
Functions for Galois field calculations
}
\keyword{internal}
