% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSLSMOTE.R
\name{RSLSMOTE}
\alias{RSLSMOTE}
\title{Relocating safe-level SMOTE with minority outcast handling}
\usage{
RSLSMOTE(x, y, k1 = 5, k2 = 5)
}
\arguments{
\item{x}{feature matrix or data.frame.}

\item{y}{a factor class variable with two classes.}

\item{k1}{number of neighbors to link. Default is 5.}

\item{k2}{number of neighbors to determine safe levels. Default is 5.}
}
\value{
a list with resampled dataset.
 \item{x_new}{Resampled feature matrix.}
 \item{y_new}{Resampled target variable.}
 \item{x_syn}{Generated synthetic data.}
 \item{C}{Number of synthetic samples for each positive class samples.}
}
\description{
The Relocating Safe-Level SMOTE (RSLS) algorithm improves the
quality of synthetic samples generated by Safe-Level SMOTE (SLS) by
relocating specific synthetic data points that are too close to the majority
class distribution towards the original minority class distribution in the
feature space.
}
\details{
In Safe-level SMOTE (SLS), a safe-level threshold is used to control the number of synthetic
samples generated from each minority instance. This threshold is calculated
based on the number of minority and majority instances in the local
neighborhood of each minority instance. SLS generates synthetic samples that
are located closer to the original minority class distribution in the feature
space.

In Relocating safe-level SMOTE (RSLS), after generating synthetic samples
using the SLS algorithm, the algorithm relocates specific synthetic data
points that are deemed to be too close to the majority class distribution in
the feature space. The relocation process moves these synthetic data points
towards the original minority class distribution in the feature space.

This relocation process is performed by first identifying the synthetic data
points that are too close to the majority class distribution. Then, for each
identified synthetic data point, the algorithm calculates a relocation vector
based on the distance between the synthetic data point and its k nearest
minority class instances. This relocation vector is used to move the
synthetic data point towards the minority class distribution in the feature
space.

Note: Much faster than \code{smotefamily::RSLS()}.
}
\examples{

set.seed(1)
x <- rbind(matrix(rnorm(2000, 3, 1), ncol = 2, nrow = 1000),
           matrix(rnorm(100, 5, 1), ncol = 2, nrow = 50))
y <- as.factor(c(rep("negative", 1000), rep("positive", 50)))

plot(x, col = y)

# resampling
m <- RSLSMOTE(x = x, y = y, k1 = 5, k2 = 5)

plot(m$x_new, col = m$y_new)

}
\references{
Siriseriwan, W., & Sinapiromsaran, K. (2016). The effective redistribution
for imbalance dataset: Relocating safe-level SMOTE with minority outcast
handling. Chiang Mai J. Sci, 43(1), 234-246.
}
\author{
Fatih Saglam, saglamf89@gmail.com
}
