% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gen_Data.R
\name{Gen_Data}
\alias{Gen_Data}
\title{Data simulator for high-dimensional GLMs}
\usage{
Gen_Data(
  n = 200,
  p = 1000,
  sigma = 1,
  num_ctgidx = NULL,
  pos_ctgidx = NULL,
  num_truecoef = NULL,
  pos_truecoef = NULL,
  level_ctgidx = NULL,
  effect_truecoef = NULL,
  correlation = c("ID", "AR", "MA", "CS"),
  rho = 0.2,
  family = c("gaussian", "binomial", "poisson")
)
}
\arguments{
\item{n}{Sample size, number of rows for the feature matrix to be generated.}

\item{p}{Number of columns for the feature matrix to be generated.}

\item{sigma}{Parameter for noise level.}

\item{num_ctgidx}{The number of features that are categorical. Set to \code{FALSE} for only numerical features. Default is \code{FALSE}.}

\item{pos_ctgidx}{Vector of indices denoting which columns are categorical.}

\item{num_truecoef}{The number of features (columns) that affect response. Default is 5.}

\item{pos_truecoef}{Vector of indices denoting which features (columns) affect the response variable. If not specified, positions are randomly sampled. See Details for more information.}

\item{level_ctgidx}{Vector to indicate the number of levels for the categorical features in \code{pos_ctgidx}. Default is 2.}

\item{effect_truecoef}{Effect size corresponding to the features in \code{pos_truecoef}. If not specified, effect size is sampled based on a uniform distribution and direction is randomly sampled.  See Details.}

\item{correlation}{Correlation structure among features. \code{correlation = "ID"} for independent,
\code{correlation = 'MA'} for moving average, \code{correlation = "CS"} for compound symmetry, \code{correlation = "AR"} 
for auto regressive Default is \code{"ID"}. For more information see Details.}

\item{rho}{Parameter controlling the correlation strength, default is \code{0.2}. See Details.}

\item{family}{Model type for the response variable.
\code{"gaussian"} for normally distributed data, \code{poisson} for non-negative counts,
\code{"binomial"} for binary (0-1).}
}
\value{
\item{call}{The call that produced this object.}
\item{Y}{Response variable vector of length \eqn{n}.}

\item{X}{Feature matrix or dataframe (matrix if \code{num_ctgidx =FALSE} and dataframe otherwise).}

\item{subset_true}{Vector of column indices of X for the features that affect the response variables (relevant features).}

\item{coef_true}{Vector of effects for the features that affect the response variables.}

\item{categorical}{Logical flag whether the model contains categorical features.}

\item{CI}{Indices of categorical features when \code{categorical = TRUE}.}

rho,family,correlation are return of arguments passed in the function call.
}
\description{
This function generates synthetic datasets from GLMs with a user-specified correlation structure.
It permits both numerical and categorical features, whose quantity can be larger than the sample size.
}
\details{
Simulated data \eqn{(y_i , x_i)} where \eqn{ x_i = (x_{i1},x_{i2} , . . . , x_{ip})} are generated as follows:
First, we generate a \eqn{p} by \eqn{1} model coefficient vector beta with all entries being zero, except for the positions specified in \code{pos_truecoef},
on which \code{effect_truecoef} is used. When \code{pos_truecoef} is not specified, we randomly choose \code{num_truecoef} positions from the coefficient
vector. When \code{effect_truecoef} is not specified, we randomly set the strength of the true model coefficients as follow:
\deqn{(0.5+U) Z,}
where \eqn{U} is sampled from a uniform distribution from 0 to 1,  and \eqn{Z} is sampled from a binomial distribution \eqn{P(Z=1)=1/2,P(Z=-1)=1/2}.

Next, we generate a \eqn{n} by \eqn{p} feature matrix \eqn{X} according to the model selected with
\code{correlation} and specified as follows.

Independent (ID):  all features are independently generated from \eqn{N( 0, 1)}.

Moving average (MA): candidate features \eqn{x_1,..., x_p} are joint normal,
marginally \eqn{N( 0, 1)}, with

\eqn{cov(x_j, x_{j-1}) = \rho}, \eqn{cov(x_j, x_{j-2}) = \rho/2} and \eqn{cov(x_j, x_h) = 0} for \eqn{|j-h|>3}.

Compound symmetry (CS): candidate features \eqn{x_1,..., x_p} are joint normal, marginally \eqn{N( 0, 1)}, with \eqn{cov(x_j, x_h) =\rho/2} if \eqn{j}, \eqn{h}
are both in the set of important features and \eqn{cov(x_j, x_h)=\rho} when only
one of \eqn{j} or \eqn{h} are in the set of important features.

Auto-regressive (AR): candidate features \eqn{x_1,..., x_p} are joint normal, marginally \eqn{N( 0, 1)}, with

\eqn{cov(x_j, x_h) = \rho^{|j-h|}} for all \eqn{j} and \eqn{h}. The correlation strength \eqn{\rho} is controlled by the argument \code{rho}. 


Then, we generate the response variable \eqn{Y} according to its response type, which is controlled by the argument \code{family}
For the Gaussian model, \eqn{y_i =x_i\beta + \epsilon_i} where \eqn{\epsilon_i} is \eqn{N( 0, 1)} for \eqn{i} from \eqn{1} to \eqn{n}. 
For the binary model let \eqn{\pi_i = P(Y = 1|x_i)}. We sample \eqn{y_i} from Bernoulli(\eqn{\pi_i}) where logit\eqn{(\pi_i) = x_i \beta}.
Finally, for the Poisson model, \eqn{y_i} is generated from the Poisson distribution with the link \eqn{\pi_i} = exp\eqn{(x_i\beta )}.
For more details see the reference below.
}
\examples{
\donttest{
#Simulating data with binomial response and auto-regressive structure.
set.seed(1)
Data <- Gen_Data(n = 500, p = 2000, family = "binomial", correlation = "AR")
cor(Data$X[,1:5])
print(Data)
}

}
\references{
Xu, C. and Chen, J. (2014). The Sparse MLE for Ultrahigh-Dimensional Feature
Screening, \emph{Journal of the American Statistical Association}, \bold{109}(507), 1257-1269
}
