% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.smle.R
\name{predict.smle}
\alias{predict.smle}
\alias{predict.selection}
\title{Prediction based on SMLE screening and selection}
\usage{
\method{predict}{smle}(object, newdata = NULL, type = c("link", "response"), ...)

\method{predict}{selection}(object, newdata = NULL, type = c("link", "response"), ...)
}
\arguments{
\item{object}{A fitted object of class \code{'smle'} , as the output from
SMLE; or \code{'selection'} as the output from smle_select.}

\item{newdata}{Matrix of new values for x at which predictions are to be made,
without the intercept term. If omitted, the fitted linear features are used.}

\item{type}{Type of prediction required. "response" gives fitted values for
"gaussian"; fitted probabilities for 'binomial', fitted mean for 'poisson'.
"link" returns prediction on the scale of the linear predictors. (Same to
"response" in "gaussian" models)}

\item{...}{Further arguments pass to predict.glm().}
}
\value{
Returns a vector of the predicted mean values of the response based on
'newdata'and the features retained in 'object'. The predicted values depend on the
model specified in 'type'.
}
\description{
Similar to the usual predict methods,this function returns predicted mean
values of the response based on the features retained in \code{'smle'} object
or selected by \code{'selection'} object.
}
\examples{

set.seed(123.456)

Data_sim<-Gen_Data(n= 200, p =1000, correlation="AR",family = "gaussian")

fit<-SMLE(Data_sim$Y,Data_sim$X, family = "gaussian")

predict(fit , type ="link")


E<-smle_select(fit, tune="ebic")

predict(E , type ="link")

}
