% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLICER.R
\name{select_k}
\alias{select_k}
\title{Select the number of nearest neighbors for LLE to use}
\usage{
select_k(exp_mat, kmin = 5, kmax = 50, by = 5)
}
\arguments{
\item{exp_mat}{Matrix of expression levels}

\item{kmin}{Smallest value of k to try}

\item{kmax}{Largest value of k to try}

\item{by}{Increment}
}
\value{
The optimal value of k
}
\description{
\code{select_k} uses the alpha-hull to determine which value
of k yields an embedding that most resembles a trajectory.
}
\examples{
\dontrun{
genes = select_genes(traj)
k = select_k(traj[,genes])
}
}
