% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsBox.R
\name{ts.box}
\alias{ts.box}
\title{Boxplots of the Medians of Subperiods}
\usage{
ts.box(x, maxbox = 200)
}
\arguments{
\item{x}{T by k data matrix: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{maxbox}{Maximum number of boxes. Default value is 200.}
}
\value{
Boxplots of the medians of subperiods.
}
\description{
Find the median of each time series in the time span and
obtain the boxplots of the medians.
}
\examples{
data(TaiwanAirBox032017)
ts.box(as.matrix(TaiwanAirBox032017[,1:10]), maxbox = 10)
}
