% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sipd_logo.R
\name{sipd_logo}
\alias{sipd_logo}
\title{Show logos of the packages inside SIPDIBGE}
\usage{
sipd_logo(survey = NULL)
}
\arguments{
\item{survey}{Name of the household survey for reference package information. If \code{NULL}, shows the logos of all the packages inside this collection, including the SIPD logo.}
}
\value{
An image with the logos required of the packages inside SIPDIBGE.
}
\description{
This function shows the survey logos of the packages inside SIPDIBGE.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/}> and consult the other functions of this package, described below.
}
\examples{
\donttest{
sipd_logo()
# Presenting information about the COVIDIBGE package
sipd_logo(survey="COVID")
# Presenting information about the PNADcIBGE package
sipd_logo(survey="PNADC")
# Presenting information about the PNSIBGE package
sipd_logo(survey="PNS")
# Presenting information about the POFIBGE package
sipd_logo(survey="POF")}
}
\seealso{
\link[SIPDIBGE]{sipd_conflicts} for indicating conflicts of the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_deps} for indicating dependencies of the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_packages} for indicating the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_sitrep} for indicating version information for the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_update} for indicating the existence of an update for the packages inside SIPDIBGE.
}
