% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L2_Colony.R
\name{removeCastePop}
\alias{removeCastePop}
\alias{removeQueen}
\alias{removeWorkers}
\alias{removeDrones}
\alias{removeVirginQueens}
\title{Remove a proportion of caste individuals from a colony}
\usage{
removeCastePop(
  x,
  caste = NULL,
  p = 1,
  use = "rand",
  addVirginQueens = FALSE,
  nVirginQueens = NULL,
  year = NULL,
  simParamBee = NULL
)

removeQueen(
  x,
  addVirginQueens = FALSE,
  nVirginQueens = NULL,
  year = NULL,
  simParamBee = NULL
)

removeWorkers(x, p = 1, use = "rand", simParamBee = NULL)

removeDrones(x, p = 1, use = "rand", simParamBee = NULL)

removeVirginQueens(x, p = 1, use = "rand", simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}}}

\item{caste}{character, "queen", "workers", "drones", or "virginQueens"}

\item{p}{numeric, proportion to be removed; if input is \code{\link[SIMplyBee]{MultiColony-class}},
the input could also be a vector of the same length as the number of colonies. If
a single value is provided, the same value will be applied to all the colonies}

\item{use}{character, all the options provided by \code{\link[AlphaSimR]{selectInd}} -
guides selection of virgins queens that will stay when \code{p < 1}}

\item{addVirginQueens}{logical, whether virgin queens should be added; only
used when removing the queen from the colony}

\item{nVirginQueens}{integer, the number of virgin queens to be created in the
colony; only used when removing the queen from the colony. If \code{0}, no virgin
queens are added; If \code{NULL}, the value from \code{simParamBee$nVirginQueens}
is used}

\item{year}{numeric, only relevant when adding virgin queens - year of birth for virgin queens}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
\code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}} without virgin queens
}
\description{
Level 2 function that removes a proportion of virgin queens of
  a Colony or MultiColony object
}
\section{Functions}{
\itemize{
\item \code{removeQueen()}: Remove queen from a colony

\item \code{removeWorkers()}: Remove workers from a colony

\item \code{removeDrones()}: Remove workers from a colony

\item \code{removeVirginQueens()}: Remove virgin queens from a colony

}}
\examples{
founderGenomes <- quickHaplo(nInd = 5, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 100)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 5, nDrones = nFathersPoisson)

# Create and cross Colony and MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(colony)
apiary <- createMultiColony(basePop[4:5], n = 2)
apiary <- cross(apiary, drones = droneGroups[3:4])
apiary <- buildUp(apiary)

# Remove workers
nWorkers(colony)
colony <- removeCastePop(colony, caste = "workers", p = 0.3)
# or alias:
colony <- removeWorkers(colony, p = 0.3)
# Same aliases exist for all the castes!!

nWorkers(apiary)
apiary <- removeCastePop(apiary, caste = "workers", p = 0.3)
nWorkers(apiary)

# Remove different proportions
apiary <- buildUp(apiary)
nWorkers(apiary)
nWorkers(removeWorkers(apiary, p = c(0.1, 0.5)))
}
