% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L2_Colony.R
\name{collapse}
\alias{collapse}
\title{Collapse}
\usage{
collapse(x)
}
\arguments{
\item{x}{\code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}}}
}
\value{
\code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}} with the collapse
  event set to \code{TRUE}
}
\description{
Level 2 function that collapses a Colony or MultiColony object
  by setting the collapse event slot to \code{TRUE}. The production status
  slot is also changed (to \code{FALSE}).
}
\details{
You should use this function in an edge-case when you
 want to indicate that the colony has collapsed, but you still want to
 collect some values from the colony for a retrospective analysis.
 It resembles a situation where the colony has collapsed, but dead
 bees are still in the hive.
}
\examples{
founderGenomes <- quickHaplo(nInd = 10, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(basePop[1], n = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = 10)

# Create Colony and MultiColony class
colony <- createColony(x = basePop[1])
colony <- cross(colony, drones = droneGroups[[1]])
apiary <- createMultiColony(x = basePop[2:10], n = 9)
apiary <- cross(apiary, drones = droneGroups[2:10])

# Collapse
hasCollapsed(colony)
colony <- collapse(colony)
hasCollapsed(colony)

hasCollapsed(apiary)
tmp <- pullColonies(apiary, n = 2)
tmp
apiaryLost <- collapse(tmp$pulled)
hasCollapsed(apiaryLost)
apiaryLeft <- tmp$remnant
hasCollapsed(apiaryLeft)
}
