% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean1_1931Hotelling.R
\name{mean1.1931Hotelling}
\alias{mean1.1931Hotelling}
\title{One-sample Hotelling's T-squared Test for Multivariate Mean}
\usage{
mean1.1931Hotelling(X, mu0 = rep(0, ncol(X)))
}
\arguments{
\item{X}{an \eqn{(n\times p)} data matrix where each row is an observation.}

\item{mu0}{a length-\eqn{p} mean vector of interest.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given a multivariate sample \eqn{X} and hypothesized mean \eqn{\mu_0}, it tests
\deqn{H_0 : \mu_x = \mu_0\quad vs\quad H_1 : \mu_x \neq \mu_0}
using the procedure by Hotelling (1931).
}
\examples{
## CRAN-purpose small example
smallX = matrix(rnorm(10*3),ncol=3)
mean1.1931Hotelling(smallX) # run the test

\dontrun{
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  X = matrix(rnorm(50*5), ncol=5)
  counter[i] = ifelse(mean1.1931Hotelling(X)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\n* Example for 'mean1.1931Hotelling'\n","*\n",
"* number of rejections   : ", sum(counter),"\n",
"* total number of trials : ", niter,"\n",
"* empirical Type 1 error : ",round(sum(counter/niter),5),"\n",sep=""))
}

}
\references{
\insertRef{hotelling_generalization_1931}{SHT}
}
\concept{mean_multivariate}
