% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov2_2012LC.R
\name{cov2.2012LC}
\alias{cov2.2012LC}
\title{Two-sample Test for High-Dimensional Covariances by Li and Chen (2012)}
\usage{
cov2.2012LC(X, Y, use.unbiased = TRUE)
}
\arguments{
\item{X}{an \eqn{(n_x \times p)} data matrix of 1st sample.}

\item{Y}{an \eqn{(n_y \times p)} data matrix of 2nd sample.}

\item{use.unbiased}{a logical; \code{TRUE} to use up to 4th-order U-statistics as proposed in the paper, \code{FALSE} for faster run under an assumption that \eqn{\mu_h = 0} (default: \code{TRUE}).}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given two multivariate data \eqn{X} and \eqn{Y} of same dimension, it tests
\deqn{H_0 : \Sigma_x = \Sigma_y\quad vs\quad H_1 : \Sigma_x \neq \Sigma_y}
using the procedure by Li and Chen (2012).
}
\examples{
## CRAN-purpose small example
smallX = matrix(rnorm(10*4),ncol=5)
smallY = matrix(rnorm(10*4),ncol=5)
cov2.2012LC(smallX, smallY) # run the test

\dontrun{
## empirical Type 1 error : use 'biased' version for faster computation
niter   = 1000
counter = rep(0,niter)
for (i in 1:niter){
  X = matrix(rnorm(500*25), ncol=10)
  Y = matrix(rnorm(500*25), ncol=10)
  
  counter[i] = ifelse(cov2.2012LC(X,Y,use.unbiased=FALSE)$p.value  < 0.05,1,0)
  print(paste0("iteration ",i,"/1000 complete.."))
}

## print the result
cat(paste("\n* Example for 'cov2.2012LC'\n","*\n",
"* number of rejections   : ", sum(counter),"\n",
"* total number of trials : ", niter,"\n",
"* empirical Type 1 error : ",round(sum(counter/niter),5),"\n",sep=""))
}

}
\references{
\insertRef{li_two_2012}{SHT}
}
\concept{covariance}
