% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepData.R
\name{prep.SEAGLE}
\alias{prep.SEAGLE}
\title{Prepare data for input into SEAGLE function}
\usage{
prep.SEAGLE(y, X, intercept, E, G)
}
\arguments{
\item{y}{Vector of observed phenotypes}

\item{X}{Matrix of covariates without genetic marker interactions}

\item{intercept}{1 if the first column of X is the all ones vector, 0 otherwise}

\item{E}{E Vector of environmental covariates}

\item{G}{G Matrix of genotype data}
}
\value{
List object containing prepared data for input into SEAGLE function
}
\description{
This function checks and formats data for input into SEAGLE function
}
\examples{
dat <- makeSimData(H=cosihap, n=500, L=10, gammaG=1, gammaGE=0, causal=4, seed=1)
objSEAGLE <- prep.SEAGLE(y=dat$y, X=dat$X, intercept=1, E=dat$E, G=dat$G)

}
