\name{SDData}
\title{Data set container of SDisc analyzes}
\description{Constructor of the data set container for SDisc analyzes. In its simplest form, it takes as input a settings file that describes the data set and an analysis prefix. It will transform the provided data matrix according to the transformation procedure described for each variable in the settings file. The resulting data set is accessible via classical R functions like: summary, plot and print. In particular, the print function returns the transformed data matrix that is passed to the cluster algorithm. }
\usage{SDData(x, dataOrig=NULL, SDTData=NULL, settings=NULL, initFun=list(SDDataCC), prefix=NULL, subset=NULL)}
\arguments{\item{x}{ a data matrix, a previously instantiated \code{SDData} container or an  \code{SDisc} object from which the \code{SDData} will be extracted, }
\item{dataOrig}{ original data, NULL by default}
\item{SDTData}{ a set of operations \code{SDTData} to apply to the data}
\item{settings}{ a data matrix as generated by \code{SDDataSettings} or the path to a CSV file separated by ";"}
\item{initFun}{ a list of function taking a data matrix as input and returning a treated matrix as output. As default, returns all complete cases records}
\item{prefix}{ a prefix that will serve to identify the analysis in the dynamic report and to define the storage place}
\item{subset}{ a subset of record indeces for the data set (row names)}
}
\details{First, the constructor makes a copy of the original data. Second, it creates the directories to store PDF's of the figures, CSV's of the tables and the RData archive of the analysis. Then, the data set is applied a set of initialization functions (e.g. complete cases, see \code{initFun}). One can also provide a \code{subset} of record indeces to issue a smaller data set from a previously instantiated data container (same settings). }
\author{Fabrice Colas}
\seealso{\code{\link{plot.SDData}}, \code{\link{print.SDData}}, \code{\link{SDData}}, \code{\link{summary.SDData}}, }\examples{settings <- SDDataSettings(iris)
settings['Species',] <- c(NA,FALSE, NA, NA, NA,NA)
x <- SDData(iris, settings=settings, prefix='iris')
summary(x)
plot(x)
summary(x)
}
\keyword{data,manip,math,models,regression}
\alias{SDData}

