% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomFolds.R
\name{randomFolds}
\alias{randomFolds}
\title{Create Random Folds}
\usage{
randomFolds(data, k, only_presence = FALSE, seed = NULL)
}
\arguments{
\item{data}{\linkS4class{SWD} object that will be used to train the model.}

\item{k}{integer. Number of fold used to create the partition.}

\item{only_presence}{logical, if \code{TRUE} the random folds are created only for
the presence locations and all the background locations are included in each
fold, used manly for presence-only methods.}

\item{seed}{integer. The value used to set the seed for the fold partition.}
}
\value{
list with two matrices, the first for the training and the second for
the testing dataset. Each column of one matrix represents a fold with
\code{TRUE} for the locations included in and \code{FALSE} excluded from the partition.
}
\description{
Create random folds for cross validation.
}
\details{
When \code{only_presence = FALSE}, the proportion of presence and absence
is preserved.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- terra::rast(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

data <- prepareSWD(species = "Virtual species", p = p_coords, a = bg_coords,
                   env = predictors, categorical = "biome")

# Create 4 random folds splitting presence and absence locations
folds <- randomFolds(data, k = 4)

# Create 4 random folds splitting only the presence locations
folds <- randomFolds(data, k = 4, only_presence = TRUE)
}
\author{
Sergio Vignali
}
