% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.placebos.R
\name{plot_placebos}
\alias{plot_placebos}
\title{Function to plot placebos of a synthetic control analysis}
\usage{
plot_placebos(
  tdf = tdf,
  discard.extreme = FALSE,
  mspe.limit = 20,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  alpha.placebos = 1,
  ...
)
}
\arguments{
\item{tdf}{An object with a list of outcome values for placebos, 
constructed by \code{\link{generate.placebos}}.}

\item{discard.extreme}{Logical. Whether or not units with high pre-treatement 
MSPE should be excluded from the plot. Takes a default of \code{FALSE}.}

\item{mspe.limit}{Numerical. Used if \code{discard.extreme} is \code{TRUE}. 
It indicates how many times the pre-treatment MSPE of a placebo should 
be higher than that of the treated unit to be considered extreme and 
discarded. Default is \code{20}.}

\item{xlab}{Character. Optional. Label of the x axis.}

\item{ylab}{Character. Optional. Label of the y axis.}

\item{title}{Character. Optional. Title of the plot.}

\item{alpha.placebos}{the transparency setting, default of \code{1}}

\item{...}{optional arguments (currently not used)}
}
\description{
Creates plots with the difference between observed units 
    and synthetic controls for the treated and control units. 
    See Abadie, Diamond, and Hainmueller (2011).
}
\examples{
\dontshow{## Example with toy data from Synth
library(Synth)
# Load the simulated data
data(synth.data)

# Execute dataprep to produce the necessary matrices for synth
dataprep.out<-
  dataprep(
    foo = synth.data,
    predictors = c("X1"),
    predictors.op = "mean",
    dependent = "Y",
    unit.variable = "unit.num",
    time.variable = "year",
    special.predictors = list(
      list("Y", 1991, "mean")
    ),
    treatment.identifier = 7,
    controls.identifier = c(29, 2, 17),
    time.predictors.prior = c(1984:1989),
    time.optimize.ssr = c(1984:1990),
    unit.names.variable = "name",
    time.plot = 1984:1996
)

# run the synth command to create the synthetic control
synth.out <- synth(dataprep.out, Sigf.ipop=1)

tdf <- generate.placebos(dataprep.out,synth.out, Sigf.ipop = 1)
## Plot the gaps in outcome values over time of each unit --
## treated and placebos -- to their synthetic controls

p <- plot_placebos(tdf,discard.extreme=TRUE, mspe.limit=10, xlab='Year')
p
}
\dontrun{## Example with toy data from Synth
library(Synth)
# Load the simulated data
data(synth.data)

# Execute dataprep to produce the necessary matrices for synth
dataprep.out<-
  dataprep(
    foo = synth.data,
    predictors = c("X1"),
    predictors.op = "mean",
    dependent = "Y",
    unit.variable = "unit.num",
    time.variable = "year",
    special.predictors = list(
      list("Y", 1991, "mean")
    ),
    treatment.identifier = 7,
    controls.identifier = c(29, 2, 13, 17),
    time.predictors.prior = c(1984:1989),
    time.optimize.ssr = c(1984:1990),
    unit.names.variable = "name",
    time.plot = 1984:1996
)

# run the synth command to create the synthetic control
synth.out <- synth(dataprep.out, Sigf.ipop=2)

## run the generate.placebos command to reassign treatment status
## to each unit listed as control, one at a time, and generate their
## synthetic versions. Sigf.ipop = 2 for faster computing time. 
## Increase to the default of 5 for better estimates. 
tdf <- generate.placebos(dataprep.out,synth.out, Sigf.ipop = 2, strategy='multiprocess')

## Plot the gaps in outcome values over time of each unit --
## treated and placebos -- to their synthetic controls

p <- plot_placebos(tdf,discard.extreme=TRUE, mspe.limit=10, xlab='Year')
p
}
}
\seealso{
\code{\link{generate.placebos}}, \code{\link[Synth]{gaps.plot}}, 
    \code{\link[Synth]{synth}}, \code{\link[Synth]{dataprep}}
}
