% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReturnModel.R
\name{ReturnModel}
\alias{ReturnModel}
\title{Performs the DIC-tau_g procedure and returns the posterior quantities of the optimal model.}
\usage{
ReturnModel(Y1, I1, Y2, I2, X, hyperparameters, inc, c, BSVSS, BDIC, Path)
}
\arguments{
\item{Y1}{Vector Containing non-terminal event times (or censoring time due to death/censoring)}

\item{I1}{Vector Containing non-terminal event indicators (1 if non-terminal event for a patient, 0 otherwise)}

\item{Y2}{Vector Containing Terminal Event times (or censoring)}

\item{I2}{Vector Containing Terminal event indicators (1 if a patients experiences a non-ternminal event, 0 if censored)}

\item{X}{Matrix of Patient Covariates. The last inc will be left out of variable selection.}

\item{hyperparameters}{List containing 29 hyperparameters and four starting values. In order they are: psi-the swap rate of the SVSS algorithm.
c-parameter involved in Sigma matrix for selection. z1a, z1b, z2a, z2b, z3a, z3b - beta hyper parameters on probability of inclusion for each of the three hazard functions.
a1,b1,a2,b2,a3,b3- hyperparameters on sigma_lambda_1, sigma_lambda_2, and sigma_lambda_3.
 clam1, clam2, clam3 - spatial dependency of baseline hazard (between 0 and 1) for the three hazard functions.
  Alpha1, Alpha2, Alpha3 - The parameter for the number of split points in hazards 1,2 and 3 (must be whole number).
  J1max, J2max, J3max - Maximum number of split points allowed (must be whole number).
  J1, J2, J3- Starting number of split points. w, psi1- hyperparameters on theta^{-1}. cep=Tuning Parameter for theta^{-1} sampler.
  epstart-Starting value for theta^{-1}. cl1,cl2,cl3-Tuning parameters for log baseline hazard height sampler.}

\item{inc}{Number of variables left out of selection.}

\item{c}{sparsity parameter involved in Sigma matrix for selection. This should be the same c as that used in the hyperparameters vector.}

\item{BSVSS}{Number of iterations to perform during the SVSS procedure. 100,000 is a reccomended value to achieve convergence.}

\item{BDIC}{Number of iterations to perform during the DIC-tau_g grid search. 10,000 is a reccomended value to achieve convergence in a reasonable amount of time.}

\item{Path}{Where to save posterior coefficient samples for the optimal model.}
}
\value{
Returns the optimal model determined by the DIC-Tau_g procedure and it's DIC along with summaries of these posterior quantities. Additionally, this function saves these posterior samples to a desired path.

 @references
[1] Lee, K. H., Haneuse, S., Schrag, D. and Dominici, F. (2015), Bayesian semi-parametric analysis of semi-competing risks data: investigating hospital readmission after a pancreatic cancer diagnosis. Journal of the Royal Statistical Society: Series C (Applied Statistics), 64: 253-273. doi: 10.1111/rssc.12078
[2] Chapple, A.C., Vannucci, M., Thall, P.F., Lin, S.(2017), Bayesian Variable selection for a semi-competing risks model with three hazard functions. Journal of Computational Statistics & Data Analysis, Volume 112, August 2017, Pages 170-185
[3] https://adventuresinstatistics.wordpress.com/2017/04/10/package-scrselect-using-returnmodel/
}
\description{
Performs the DIC-tau_g procedure by first running the function SCRSELECTRUN with 60 percent burnin, which performs SVSS on two disperse starting values for beta1,beta2,beta3. Afterwards, the function DICTAUG is used to extract the DIC values for unique models visited by the grid search and the optimal model is determined as the one with the lowest DIC which is the most parsimonius. After the optimal model is determined, one final MCMC is performed to obtain posterior beta1,beta2 and beta3 quantities for this model, returning summary values for each hazard.
}
\examples{
####Randomly Generate Semicompeting Risks Data
set.seed(1)
####Generates random patient time, indicator and covariates.
n=100
Y1=runif(n,0,100)
I1=rbinom(n,1,.5)
Y2=Y1
I2=I1
for(i in 1:n){if(I1[i]==0){Y2[i]=Y1[i]}else{Y2[i]=Y1[i]+runif(1,0,100)}}
I2=rbinom(n,1,.5)
library(mvtnorm)
X=rmvnorm(n,rep(0,7),diag(7))
####Read in Hyperparameters
##Swap Rate
psi=.5
c=5
###Eta Beta function probabilities
z1a=.4
z1b=1.6
z2a=.4
z2b=1.6
z3a=.4
z3b=1.6
####Hierarchical lam params
###Sigma^2 lambda_g hyperparameters
a1=.7
b1=.7
a2=a1
b2=b1
a3=a1
b3=b1
##Spacing dependence c in [0,1]
clam1=1
clam2=1
clam3=1
#####NumSplit
alpha1=3
alpha2=3
alpha3=3
J1max=10
J2max=10
J3max=10
####Split Point Starting Value ###
J1=3
J2=3
J3=3
###epsilon starting values/hyperparameters###
w=.7
psi1=.7
cep=2.4
#############
epstart=1.5
cl1=.25
cl2=.25
cl3=.25
###Beta Starting Values
hyper1=c(psi,c,z1a,z1b,z2a,z2b,z3a,z3b,a1,b1,a2,b2,a3,b3,clam1,clam2,clam3)
hyper2=c(alpha1,alpha2,alpha3,J1max,J2max,J3max,J1,J2,J3,w,psi1,cep,epstart,cl1,cl2,cl3)
hyper=c(hyper1,hyper2)
###Number of iterations and output location
BSVSS=10
BDIC=4
Path=tempdir()
###Number of variables to exclude from selection and burnin percent
inc=2
ReturnModel(Y1,I1,Y2,I2,X,hyper,inc,c,BSVSS,BDIC,Path)
}
