% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ADMMc}
\alias{ADMMc}
\title{Penalized precision matrix estimation via ADMM (c++)}
\usage{
ADMMc(S, A, B, C, initOmega, initZ, initY, lam, alpha = 1, tau = 10,
  rho = 2, mu = 10, tau_rho = 2, iter_rho = 10L, crit = "ADMM",
  tol_abs = 1e-04, tol_rel = 1e-04, maxit = 10000L)
}
\arguments{
\item{S}{pxp sample covariance matrix (denominator n).}

\item{A}{option to provide user-specified matrix for penalty term. This matrix must have p columns. Defaults to identity matrix.}

\item{B}{option to provide user-specified matrix for penalty term. This matrix must have p rows. Defaults to identity matrix.}

\item{C}{option to provide user-specified matrix for penalty term. This matrix must have nrow(A) rows and ncol(B) columns. Defaults to identity matrix.}

\item{initOmega}{initialization matrix for Omega}

\item{initZ}{initialization matrix for Z2}

\item{initY}{initialization matrix for Y}

\item{lam}{postive tuning parameter for elastic net penalty.}

\item{alpha}{elastic net mixing parameter contained in [0, 1]. \code{0 = ridge, 1 = lasso}. Alpha must be a single value (cross validation across alpha not supported).}

\item{tau}{optional constant used to ensure positive definiteness in Q matrix in algorithm}

\item{rho}{initial step size for ADMM algorithm.}

\item{mu}{factor for primal and residual norms in the ADMM algorithm. This will be used to adjust the step size \code{rho} after each iteration.}

\item{tau_rho}{factor in which to increase step size \code{rho}.}

\item{iter_rho}{step size \code{rho} will be updated every \code{iter.rho} steps}

\item{crit}{criterion for convergence (\code{ADMM} or \code{loglik}). If \code{crit = loglik} then iterations will stop when the relative change in log-likelihood is less than \code{tol.abs}. Default is \code{ADMM} and follows the procedure outlined in Boyd, et al.}

\item{tol_abs}{absolute convergence tolerance. Defaults to 1e-4.}

\item{tol_rel}{relative convergence tolerance. Defaults to 1e-4.}

\item{maxit}{maximum number of iterations. Defaults to 1e4.}
}
\value{
returns list of returns which includes:
\item{Iterations}{number of iterations.}
\item{lam}{optimal tuning parameter.}
\item{Omega}{estimated penalized precision matrix.}
\item{Z2}{estimated Z matrix.}
\item{Y}{estimated Y matrix.}
\item{rho}{estimated rho.}
}
\description{
Penalized precision matrix estimation using the ADMM algorithm
}
\details{
For details on the implementation of 'ADMMsigma', see the vignette
\url{https://mgallow.github.io/SCPME/}.
}
\references{
\itemize{
\item Boyd, Stephen, Neal Parikh, Eric Chu, Borja Peleato, Jonathan Eckstein, and others. 2011. 'Distributed Optimization and Statistical Learning via the Alternating Direction Method of Multipliers.' \emph{Foundations and Trends in Machine Learning} 3 (1). Now Publishers, Inc.: 1-122. \url{https://web.stanford.edu/~boyd/papers/pdf/admm_distr_stats.pdf}
\item Hu, Yue, Chi, Eric C, amd Allen, Genevera I. 2016. 'ADMM Algorithmic Regularization Paths for Sparse Statistical Machine Learning.' \emph{Splitting Methods in Communication, Imaging, Science, and Engineering}. Springer: 433-459.
\item Molstad, Aaron J., and Adam J. Rothman. (2017). 'Shrinking Characteristics of Precision Matrix Estimators. \emph{Biometrika.}. \url{https://doi.org/10.1093/biomet/asy023}
\item Rothman, Adam. 2017. 'STAT 8931 notes on an algorithm to compute the Lasso-penalized Gaussian likelihood precision matrix estimator.'
}
}
\author{
Matt Galloway \email{gall0441@umn.edu}
}
\keyword{internal}
