% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table.R
\name{table_exists}
\alias{table_exists}
\title{Test if a table exists in database}
\usage{
table_exists(conn, db_table_id)
}
\arguments{
\item{conn}{An object that inherits from DBIConnection (as generated by get_connection())'}

\item{db_table_id}{A \code{\link[DBI:Id]{DBI::Id()}} object or a character string readable by \link{id}.}
}
\value{
TRUE if db_table_id can be parsed to a table found in conn
}
\description{
Test if a table exists in database
}
\examples{
conn <- get_connection(drv = RSQLite::SQLite())

dplyr::copy_to(conn, mtcars, name = "mtcars")

table_exists(conn, "mtcars") # TRUE
table_exists(conn, "iris") # FALSE

close_connection(conn)
}
