% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samLL.R
\name{predict.samLL}
\alias{predict.samLL}
\title{Prediction function for S3 class \code{"samLL"}}
\usage{
\method{predict}{samLL}(object, newdata, thol = 0.5, ...)
}
\arguments{
\item{object}{An object with S3 class \code{"samLL"}.}

\item{newdata}{The testing dataset represented in a \code{n} by \code{d} matrix, where \code{n} is testing sample size and \code{d} is dimension.}

\item{thol}{The decision value threshold for prediction. The default value is 0.5}

\item{\dots}{System reserved (No specific usage)}
}
\value{
\item{probs}{
  Estimated Posterior Probability for Prediction also represented in a \code{n} by the length of \code{lambda} matrix, where \code{n} is testing sample size.
}
\item{labels}{
  Predicted labels also represented in a \code{n} by the length of \code{lambda} matrix, where \code{n} is testing sample size. }
}
\description{
Predict the labels for testing data.
}
\details{
The testing dataset is rescale to the samLLe range, and expanded by the samLLe spline basis functions as the training data.
}
\seealso{
\code{\link{samLL}}
}
