% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_SAEforest.R
\name{summary.SAEforest}
\alias{summary.SAEforest}
\title{Summarizes an 'SAEforest' object}
\usage{
\method{summary}{SAEforest}(object, ...)
}
\arguments{
\item{object}{An object of class \code{SAEforest} representing point
and MSE estimates. Objects differ depending on the estimation method.}

\item{...}{Optional additional inputs that are ignored for this method.}
}
\value{
An object of class \code{summary.SAEforest} including information about the sample
and population data, the model fit and random forest specific metrics.
}
\description{
Shows additional information about the data, the SAE model and its components.
Information is extracted from a \code{SAEforest} object. The returned object
is suitable for printing with \code{print}.
}
\examples{
\donttest{
# Loading data
data("eusilcA_pop")
data("eusilcA_smp")

income <- eusilcA_smp$eqIncome
X_covar <- eusilcA_smp[, -c(1, 16, 17, 18)]

# Example 1:
# Calculating point estimates and discussing basic generic functions

model1 <- SAEforest_model(Y = income, X = X_covar, dName = "district",
                         smp_data = eusilcA_smp, pop_data = eusilcA_pop,
                         num.trees=50, mtry=3)

# SAEforest generics:
summary(model1)
}
}
\seealso{
\code{\link{SAEforestObject}}
}
