% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inherits.R
\name{S7_inherits}
\alias{S7_inherits}
\alias{check_is_S7}
\title{Does this object inherit from an S7 class?}
\usage{
S7_inherits(x, class = NULL)

check_is_S7(x, class = NULL, arg = deparse(substitute(x)))
}
\arguments{
\item{x}{An object}

\item{class}{An S7 class or \code{NULL}. If \code{NULL}, tests whether \code{x} is an
S7 object without testing for a specific class.}

\item{arg}{Argument name used in error message.}
}
\value{
\itemize{
\item \code{S7_inherits()} returns a single \code{TRUE} or \code{FALSE}.
\item \code{check_is_S7()} returns nothing; it's called for its side-effects.
}
}
\description{
\itemize{
\item \code{S7_inherits()} returns \code{TRUE} or \code{FALSE}.
\item \code{check_is_S7()} throws an error if \code{x} isn't the specified \code{class}.
}
}
\examples{
foo1 <- new_class("foo1")
foo2 <- new_class("foo2")

S7_inherits(foo1(), foo1)
check_is_S7(foo1())
check_is_S7(foo1(), foo1)

S7_inherits(foo1(), foo2)
try(check_is_S7(foo1(), foo2))
}
