% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{rxProgress}
\alias{rxProgress}
\alias{rxTick}
\alias{rxProgressStop}
\alias{rxProgressAbort}
\title{RxODE progress bar functions}
\usage{
rxProgress(num, core = 0L)

rxTick()

rxProgressStop(clear = TRUE)

rxProgressAbort(error = "Aborted calculation")
}
\arguments{
\item{num}{Tot number of operations to track}

\item{core}{Number of cores to show.  If below 1, don't show
number of cores}

\item{clear}{Boolean telling if you should clear the progress bar
after completion (as if it wasn't displayed).  By default this is TRUE}

\item{error}{With rxProgressAbort this is the error that is displayed}
}
\value{
All return NULL invisibly.
}
\description{
\code{rxProgress} sets up the progress bar
}
\details{
\code{rxTick} is a progress bar tick

\code{rxProgressStop} stop progress bar

\code{rxProgressAbort} shows an abort if \code{rxProgressStop}
wasn't called.
}
\examples{
f <- function(){
  on.exit({rxProgressAbort()});
  rxProgress(100)
    for (i in 1:100) {
       rxTick()
       Sys.sleep(1 / 100)
    }
  rxProgressStop();
 }

\donttest{
f()
}

}
\author{
Matthew L. Fidler
}
