% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxJacobian.R
\name{.rxGenFocei}
\alias{.rxGenFocei}
\title{Generate pieces for FOCEi inner problem}
\usage{
.rxGenFocei(
  obj,
  predfn,
  pkpars = NULL,
  errfn = NULL,
  init = NULL,
  pred.minus.dv = TRUE,
  sum.prod = FALSE,
  optExpression = TRUE,
  promoteLinSens = TRUE,
  theta = FALSE,
  addProp = c("combined2", "combined1")
)
}
\arguments{
\item{obj}{RxODE object}

\item{predfn}{Prediction function}

\item{pkpars}{Pk Pars function}

\item{errfn}{Error function}

\item{init}{Initialization parameters for scaling.}

\item{pred.minus.dv}{Boolean stating if the FOCEi objective
function is based on PRED-DV (like NONMEM).  Default TRUE.}

\item{sum.prod}{A boolean determining if RxODE should use more
numerically stable sums/products.}

\item{optExpression}{Optimize the model text for computer
evaluation.}

\item{promoteLinSens}{Promote solved linear compartment systems to
sensitivity-based solutions.}

\item{theta}{Calculate THETA derivatives instead of ETA
derivatives.  By default FALSE}

\item{addProp}{one of "combined1" and "combined2"; These are the
two forms of additive+proportional errors supported by
monolix/nonmem:

combined1: transform(y)=transform(f)+(a+b*f^c)*eps

combined2: transform(y)=transform(f)+(a^2+b^2*f^(2c))*eps}
}
\value{
RxODE/symengine environment
}
\description{
Generate pieces for FOCEi inner problem
}
\author{
Matthew L. Fidler
}
