% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDict.R
\name{createDict}
\alias{createDict}
\title{Create a dictionary file from corpus.}
\usage{
createDict(trainvec, dicfile = NULL, wordsplit = "\\\\s+",
  natruesplit = "/")
}
\arguments{
\item{trainvec}{A character vector of corpus.}

\item{dicfile}{The path of output file. Defult is NULL.}

\item{wordsplit}{Character containing regular expression to use for splitting words.}

\item{natruesplit}{Character containing regular expression to use for splitting nature.}
}
\value{
A data frame of: 
 \item{word}{Word.}
 \item{freq}{Frequency.}
 \item{nature}{Nature.}
}
\description{
Read a corpus vector and generate the dictionary data frame.
}
\examples{
data(PD980105)
d1 <- createDict(PD980105[1:10])
head(d1)

}
\author{
Jian Li <\email{rweibo@sina.com}>
}
