\name{Rvmminb}
\alias{Rvmminb}
\encoding{UTF-8}
\title{Variable metric nonlinear function minimization with bounds constraints}
\description{A bounds-constarined R implementation of a variable metric method for minimization
of nonlinear functions subject to bounds (box) constraints and masks 
(fixed parameters). 

   See manual Rvmmin.Rd for more details and examples.
}
\usage{
   Rvmminb(par, fn, gr, lower, upper, bdmsk, control = list(), \dots)
}
\arguments{
 \item{par}{A numeric vector of starting estimates.}
 \item{fn}{A function that returns the value of the objective at the
   supplied set of parameters \code{par} using auxiliary data in \dots.
   The first argument of \code{fn} must be \code{par}. }
 \item{gr}{A function that returns the gradient of the objective at the
   supplied set of parameters \code{par} using auxiliary data in \dots.
   The first argument of \code{fn} must be \code{par}. This function 
   returns the gradient as a numeric vector.

   Note that a gradient function MUST be provided. However, there is the
   option of using the routines grfwd(), grback(), grcentral() or grnd()
   from package . The last of these calls the grad() function 
   from package numDeriv. These are called by putting the name of the
   numerical gradient function in quotation marks, e.g.,

      gr="grfwd"

   to use the standard forward difference numerical approximation.

   The use of numerical gradients for Rvmminb is STRONGLY discouraged.
   See the manual Rvmmin.Rd for more explanation.}
 \item{lower}{A vector of lower bounds on the parameters.}
 \item{upper}{A vector of upper bounds on the parameters.}
 \item{bdmsk}{An indicator vector, having 1 for each parameter that is "free" or
     unconstrained, and 0 for any parameter that is fixed or MASKED for the
     duration of the optimization.}
 \item{control}{
    An optional list of control settings.
 }
 \item{\dots}{Further arguments to be passed to \code{fn}.}
}
\details{
  This routine is intended to be called from \code{Rvmmin}, which will, if
  necessary, supply a gradient approximation. However, some users will want
  to avoid the extra overhead, in which case it is important to provide an
  appropriate and high-accuracy gradient routine.

  Functions \code{fn} must return a numeric value.
  The \code{control} argument is a list.
    Successful completion.
    The source code \code{Rvmmin} for R is still a work in progress, so users should watch
    the console output.

   The \code{control} argument is a list.
   \describe{
   \item{maxit}{A limit on the number of iterations (default 500). Note that this is 
      used to compute a quantity \code{maxfeval}<-round(sqrt(n+1)*maxit) where n is the
      number of parameters to be minimized.}
   \item{trace}{Set 0 (default) for no output, >0 for trace output
      (larger values imply more output).}
   \item{eps}{Tolerance used to calculate numerical gradients. Default is 1.0E-7. See 
      source code for \code{Rvmmin} for details of application.}
   \item{\code{dowarn}}{= TRUE if we want warnings generated by optimx. Default is 
     TRUE.}
   \item{\code{keepinputpar}}{= TRUE if we want bounds check to stop program when parameters
     are out of bounds. Else when FALSE, moves parameter values to nearest bound. Default is 
     FALSE.}
   \item{maximize}{To maximize user_function, supply a function that computes (-1)*user_function.
       An alternative is to call Rvmmin via the package optimx.}
   \item{acctol}{To adjust the acceptable point tolerance (default 0.0001) in the test
       f <= fmin + gradproj * steplength * acctol }
  }

  As of 2011-11-21 the following controls have been REMOVED

  \describe{
   \item{usenumDeriv}{There is now a choice of numerical gradient routines. See argument 
       \code{gr}.}
  }
}

\value{
  A list with components:
  \item{par}{The best set of parameters found.}
  \item{value}{The value of the objective at the best set of parameters found.}
  \item{counts}{A vector of two integers giving the number of function and gradient evaluations.}
  \item{convergence}{An integer indicating the situation on termination of the function. \code{0}
   indicates that the method believes it has succeeded. Other values:
   \describe{
      \item{\code{1}}{indicates that the iteration limit \code{maxit}
      had been reached.}
      \item{\code{20}}{indicates that the initial set of parameters is inadmissible, that is,
	that the function cannot be computed or returns an infinite, NULL, or NA value.}
      \item{\code{21}}{indicates that an intermediate set of parameters is inadmissible.}
   }
  }
  \item{message}{A description of the situation on termination of the function.}
  \item{bdmsk}{Returned index describing the status of bounds and masks at the
        proposed solution. Parameters for which bdmsk are 1 are unconstrained
        or "free", those with bdmsk 0 are masked i.e., fixed. For historical
        reasons, we indicate a parameter is at a lower bound using -3 
         or upper bound using -1.}
}
\references{
  Fletcher, R (1970) ...

  Nash, J C (1979, 1990) ...

To be added.
}
\seealso{\code{\link{optim}}}
\examples{
## See Rvmmin.Rd

}

\keyword{nonlinear}
\keyword{optimize}

