% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_functions.R
\name{tsEvaTransformSeriesToStationaryTrendAndChangepts}
\alias{tsEvaTransformSeriesToStationaryTrendAndChangepts}
\title{Transform Time Series to Stationary Trend and Change Points}
\usage{
tsEvaTransformSeriesToStationaryTrendAndChangepts(
  timeStamps,
  series,
  timeWindow
)
}
\arguments{
\item{timeStamps}{A vector of time stamps corresponding to the data points in the series.}

\item{series}{The original time series data.}

\item{timeWindow}{The size of the time window used for detrending.}
}
\value{
A list containing the following elements:
\describe{
\item{\code{runningStatsMulteplicity}}{The running statistics multiplicity.}
\item{\code{stationarySeries}}{The transformed stationary series.}
\item{\code{trendSeries}}{The trend series.}
\item{\code{trendonlySeries}}{The trend series without the stationary component.}
\item{\code{ChpointsSeries2}}{The trend component of the change points.}
\item{\code{changePoints}}{The detected change points.}
\item{\code{trendSeriesNonSeasonal}}{The trend series without the seasonal component.}
\item{\code{trendError}}{The error on the trend.}
\item{\code{stdDevSeries}}{The slowly varying standard deviation series.}
\item{\code{stdDevSeriesNonStep}}{The slowly varying standard deviation series without step changes.}
\item{\code{stdDevError}}{The error on the standard deviation.}
\item{\code{timeStamps}}{The time stamps.}
\item{\code{nonStatSeries}}{The original non-stationary series.}
\item{\code{statSer3Mom}}{The running mean of the third moment of the stationary series.}
\item{\code{statSer4Mom}}{The running mean of the fourth moment of the stationary series.}
}
}
\description{
This function takes a time series and transforms it into a stationary trend series
by removing the trend component and detecting change points. It computes the slowly
varying standard deviation and normalizes the stationary series before detecting
step changes. It also calculates the error on the trend and standard deviation.
}
\examples{
timeAndSeries <- ArdecheStMartin
timeStamps <- ArdecheStMartin[,1]
series <- ArdecheStMartin[,2]
#select only the 5 latest years
yrs <- as.integer(format(timeStamps, "\%Y"))
tokeep <- which(yrs>=2015)
timeStamps <- timeStamps[tokeep]
series <- series[tokeep]
timeWindow <- 365 # 1 year
percentile <- 90
result <- tsEvaTransformSeriesToStationaryTrendAndChangepts(timeStamps,
series, timeWindow)
plot(result$trendSeries)

}
