% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tile_geoprocessor}
\alias{tile_geoprocessor}
\title{Split a raster grid into tiles for tile-based processing}
\usage{
tile_geoprocessor(x, grid, nx, ny, overlap = 0, file_path = NULL)
}
\arguments{
\item{x}{A `saga` object.}

\item{grid}{A path to a GDAL-supported raster to apply tiling, or a
RasterLayer.}

\item{nx}{An integer with the number of x-pixels per tile.}

\item{ny}{An integer with the number of y-pixels per tile.}

\item{overlap}{An integer with the number of overlapping pixels.}

\item{file_path}{An optional file file path to store the raster tiles.}
}
\value{
A list of RasterLayer objects representing tiled data.
}
\description{
Split a raster grid into tiles. The tiles are saved as Rsagacmd
temporary files, and are loaded as a list of R objects for further
processing. This is a function to make the the SAGA-GIS
grid_tools / tiling tool more convenient to use.
}
\examples{
\dontrun{
# Initialize a saga object
saga <- saga_gis()

# Generate a random DEM
dem <- saga$grid_calculus$random_terrain(radius = 15, iterations = 500)

# Return tiled version of DEM
tiles <- tile_geoprocessor(x = saga, grid = dem, nx = 20, ny = 20)
}
}
