% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rprofet.R
\name{ScorecardFUN}
\alias{ScorecardFUN}
\title{Scorecard Builder}
\usage{
ScorecardFUN(dat, target, id, varcol, PDO = 100, BaseOdds = 10,
  BasePts = 1000)
}
\arguments{
\item{dat}{Dataframe containing the WOE binned variables.}

\item{target}{A binary target variable.}

\item{id}{ID variable.}

\item{varcol}{Vector of variables to be used in the logistic regression model.}

\item{PDO}{Points to Double Odds.}

\item{BaseOdds}{Base Odds.}

\item{BasePts}{Base Points.}
}
\value{
A list with the following components.
\item{Scorecard}{Dataframe with the points assigned to each attribute and the total score for each observation.}
\item{GLMSummary}{The summary of the logistic regression model fitted to build the scorecard.}
}
\description{
Function that fits a logistic regression models and scores points for each bin and calculates observations' total score.
}
\examples{
mydata <- ISLR::Default

mydata$ID = seq(1:nrow(mydata)) ## make the ID variable
mydata$default<-ifelse(mydata$default=="Yes",1,0) ## Creating numeric binary target variable

binned <- BinFun3(mydata, id= "ID", target= "default", num.bins = 5) ## Binning variables

WOE_dat <- WOEFun3(binned, "ID","default", 3:5) ## WOE transformation of bins

Score_dat <- ScorecardFUN(WOE_dat$WOE, target="default",
                                    id= "ID", PDO = 50, BaseOdds = 10, BasePts = 1000)

Score_dat$GLMSummary
head(Score_dat$Scorecard) ## More points means more likely to default


}
