% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{update_b}
\alias{update_b}
\title{Update class means}
\usage{
update_b(beta, Omega, z, m, xi, Dinv)
}
\arguments{
\item{beta}{The matrix of the decision-maker specific coefficient vectors of dimension
\code{P_r} x \code{N}.
Set to \code{NA} if \code{P_r = 0}.}

\item{Omega}{The matrix of class covariance matrices as columns of dimension
\code{P_r*P_r} x \code{C}.
Set to \code{NA} if \code{P_r = 0}.}

\item{z}{The vector of the allocation variables of length \code{N}.
Set to \code{NA} if \code{P_r = 0}.}

\item{m}{The vector of class sizes of length \code{C}.}

\item{xi}{The mean vector of length \code{P_r} of the normal prior for each \code{b_c}.
Per default, \code{xi = numeric(P_r)}.}

\item{Dinv}{The precision matrix (i.e. the inverse of the covariance matrix) of dimension \code{P_r} x \code{P_r}
of the normal prior for each \code{b_c}.}
}
\value{
A matrix of updated means for each class in columns.
}
\description{
This function updates the class means (independent from the other classes).
}
\details{
The following holds independently for each class \eqn{c}.
Let \eqn{b_c} be the mean of class number \eqn{c}. A priori, we assume that \eqn{b_c} is normally distributed
with mean vector \eqn{\xi} and covariance matrix \eqn{D}.
Let \eqn{(\beta_n)_{z_n=c}} be the collection of \eqn{\beta_n} that are currently allocated to class \eqn{c},
\eqn{m_c} the class size, and \eqn{\bar{b}_c} their arithmetic mean.
Assuming independence across draws, \eqn{(\beta_n)_{z_n=c}} has
a normal likelihood of \deqn{\prod_n \phi(\beta_n \mid b_c,\Omega_c),} where the product is over the values \eqn{n}
for which \eqn{z_n=c} holds.
Due to the conjugacy of the prior, the posterior \eqn{\Pr(b_c \mid (\beta_n)_{z_n=c})} follows a normal distribution
with mean \deqn{(D^{-1} + m_c\Omega_c^{-1})^{-1}(D^{-1}\xi + m_c\Omega_c^{-1}\bar{b}_c)} and covariance matrix
\deqn{(D^{-1} + m_c \Omega_c^{-1})^{-1}.}
}
\examples{
### N = 100 decider, P_r = 2 random coefficients, and C = 2 latent classes
N <- 100
(b_true <- cbind(c(0,0),c(1,1)))
Omega <- matrix(c(1,0.3,0.3,0.5,1,-0.3,-0.3,0.8), ncol=2)
z <- c(rep(1,N/2),rep(2,N/2))
m <- as.numeric(table(z))
beta <- sapply(z, function(z) rmvnorm(b_true[,z], matrix(Omega[,z],2,2)))
### prior mean vector and precision matrix (inverse of covariance matrix)
xi <- c(0,0)
Dinv <- diag(2)
### updated class means (in columns)
update_b(beta = beta, Omega = Omega, z = z, m = m, xi = xi, Dinv = Dinv)
}
\keyword{internal}
\keyword{posterior}
