% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_management.R
\name{train_test}
\alias{train_test}
\title{Split choice data in train and test subset}
\usage{
train_test(
  x,
  test_proportion = NULL,
  test_number = NULL,
  by = "N",
  random = FALSE,
  seed = NULL
)
}
\arguments{
\item{x}{An object of class \code{RprobitB_data}.}

\item{test_proportion}{A number between 0 and 1, the proportion of the test subsample.}

\item{test_number}{A positive integer, the number of observations in the test subsample.}

\item{by}{One of \code{"N"} (split by deciders) and \code{"T"} (split by choice
occasions).}

\item{random}{If \code{TRUE}, the subsamples are build randomly.}

\item{seed}{Set a seed for building the subsamples randomly.}
}
\value{
A list with two objects of class \code{RprobitB_data}, named \code{"train"}
and \code{"test"}.
}
\description{
This function splits choice data into a train and a test part.
}
\details{
See \href{https://loelschlaeger.de/RprobitB/articles/v02_choice_data.html}{the vignette on choice data}
for more details.
}
\examples{
### simulate choices for demonstration
x <- simulate_choices(form = choice ~ covariate, N = 10, T = 10, J = 2)

### 70\% of deciders in the train subsample,
### 30\% of deciders in the test subsample
train_test(x, test_proportion = 0.3, by = "N")

### 2 randomly chosen choice occasions per decider in the test subsample,
### the rest in the train subsample
train_test(x, test_number = 2, by = "T", random = TRUE, seed = 1)

}
