% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_form.R
\name{check_form}
\alias{check_form}
\title{Check \code{form}.}
\usage{
check_form(form, re = NULL)
}
\arguments{
\item{form}{A formula object that is used to specify the probit model.
The structure is \code{choice ~ A | B | C}, where
\itemize{
\item \code{A} are names of alternative and choice situation specific
covariates with a generic coefficient,
\item \code{B} are names of choice situation specific covariates with
alternative specific coefficients,
\item and \code{C} are names of alternative and choice situation specific
covariates with alternative specific coefficients.
}
Separate multiple covariates of one type by a \code{+} sign.
By default, alternative specific constants (ASCs) are added to the model
(for all except for the last alternative).
They can be removed by adding \code{+0} in the second spot.
See the vignette \code{vignette("data_management", package = "RprobitB")}
for more details.}

\item{re}{A character (vector) of covariates of \code{form} with random effects.
If \code{re = NULL} (the default), there are no random effects.
To have random effects for the alternative specific constants, include
\code{"ASC"} in \code{re}.}
}
\value{
\itemize{
\item \code{choice}:
The dependent variable in \code{form}.
\item \code{re}:
The input \code{re}, where covariates that are not part of \code{form}
are removed.
\item \code{vars}:
A list of three character vectors of covariate names of the three
covariate types.
\item \code{ASC}:
A boolean, determining whether the model has ASCs.
}
}
\description{
This function checks the input \code{form}.
}
\keyword{internal}
