% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activities.update.R
\name{activities.update}
\alias{activities.update}
\title{Edit an activity}
\usage{
activities.update(id, subject = NULL, done = NULL, type = NULL,
  due_date = NULL, due_time = NULL, duration = NULL,
  user_id = NULL, deal_id = NULL, person_id = NULL,
  participants = NULL, org_id = NULL, note = NULL,
  api_token = NULL, company_domain = "api",
  return_type = c("complete", "boolean"))
}
\arguments{
\item{id}{ID of the activity}

\item{subject}{Subject of the activity. When omitted, will remain unchanged.}

\item{done}{Whether the activity is done or not. 0 = Not done, 1 = Done This field has the following domains: (0; 1)}

\item{type}{Type of the activity. This is in correlation with the key_string parameter of ActivityTypes.}

\item{due_date}{Due date of the activity. Format: YYYY-MM-DD}

\item{due_time}{Due time of the activity in UTC. Format: HH:MM}

\item{duration}{Duration of the activity. Format: HH:MM}

\item{user_id}{ID of the user whom the activity will be assigned to}

\item{deal_id}{ID of the deal this activity will be associated with}

\item{person_id}{ID of the person this activity will be associated with}

\item{participants}{List of multiple persons (participants) this activity will be associated with. If omitted, single participant from person_id field is used. It requires a structure as follows: [{person_id:1,primary_flag:true}] this field must be a JSON.}

\item{org_id}{ID of the organization this activity will be associated with}

\item{note}{Note of the activity (HTML format). When omitted, will remain unchanged.}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Edit an activity on pipedrive.
}
\examples{
\donttest{
activities.update(id='e.g.',api_token='token',company_domain='exp')
}
}
