% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/products.find.R
\name{products.find}
\alias{products.find}
\title{Find products by name}
\usage{
products.find(term, currency = NULL, start = NULL, limit = NULL,
  api_token = NULL, company_domain = "api")
}
\arguments{
\item{term}{Search term to look for, minimum 3 characters.}

\item{currency}{Currency code in which prices should be returned in. If omitted, prices in user's default currency will be returned.}

\item{start}{Pagination start}

\item{limit}{Items shown per page}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to Find products by name from pipedrive.
}
\examples{
\donttest{
products.find(term='e.g.',api_token='token',company_domain='exp')
}
}
