% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.update.R
\name{filters.update}
\alias{filters.update}
\title{Update filter}
\usage{
filters.update(id, conditions, name = NULL, api_token = NULL,
  company_domain = "api", return_type = c("complete", "boolean"))
}
\arguments{
\item{id}{ID of the filter to update.}

\item{conditions}{Filter conditions as a JSON object. It requires a minimum structure as follows: {glue:and,conditions:[{glue:and,conditions: [CONDITION_OBJECTS]},{glue:or,conditions:[CONDITION_OBJECTS]}]}. Replace CONDITION_OBJECTS with JSON objects of the following structure: {object:,field_id:, operator:,value:, extra_value:} or leave the array empty.}

\item{name}{Filter name}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Update filter on pipedrive.
}
\examples{
\donttest{
filters.update(id='e.g.',conditions='e.g.',api_token='token',company_domain='exp')
}
}
