% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers_mahalanobis.R
\name{outliers_mahalanobis}
\alias{outliers_mahalanobis}
\title{mahalanobis function to detect outliers}
\usage{
outliers_mahalanobis(x, alpha, na.rm)
}
\arguments{
\item{x}{matrix of bivariate values from which we want to compute outliers}

\item{alpha}{nominal type I error probability (by default .01)}

\item{na.rm}{set whether Missing Values should be excluded (na.rm = TRUE) or not (na.rm = FALSE) - defaults to TRUE}
}
\value{
Returns Call, Max distance, number of outliers
}
\description{
Detecting multivariate outliers using the Mahalanobis distance
}
\examples{
#### Run outliers_mahalanobis
data(Attacks)
SOC <- rowMeans(Attacks[,c("soc1r","soc2r","soc3r","soc4","soc5","soc6","soc7r",
"soc8","soc9","soc10r","soc11","soc12","soc13")])
HSC <- rowMeans(Attacks[,22:46])
res <- outliers_mahalanobis(x = cbind(SOC,HSC), na.rm = TRUE)
# A list of elements can be extracted from the function,
# such as the position of outliers in the dataset
# and the coordinates of outliers
res$outliers_pos
res$outliers_val

}
\keyword{mahalanobis}
\keyword{outliers}
