% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MissingValue.R
\name{MV.globalClosestFit}
\alias{MV.globalClosestFit}
\title{Global Closest Fit}
\usage{
MV.globalClosestFit(decision.table)
}
\arguments{
\item{decision.table}{a \code{"DecisionTable"} class representing a decision table. See \code{\link{SF.asDecisionTable}}. 
Note: missing values are recognized as NA.}
}
\value{
A class \code{"MissingValue"}. See \code{\link{MV.missingValueCompletion}}.
}
\description{
It is used for handling missing values based on the global closest fit.
}
\details{
The global closes fit method is based on replacing
a missing attribute value by the known value in another case that resembles
as much as possible the case with the missing attribute value. In searching
for the closest fit case we compare two vectors of attribute values, one vector
corresponds to the case with a missing attribute value, the other vector is a candidate
for the closest fit. The search is conducted for all cases, hence the name
global closest fit. For each case a distance is computed, the case for which the
distance is the smallest is the closest fitting case that is used to determine the
missing attribute value.
}
\examples{
#############################################
## Example: Global Closest Fit
#############################################
dt.ex1 <- data.frame(
     c(100.2, 102.6, NA, 99.6, 99.8, 96.4, 96.6, NA), 
     c(NA, "yes", "no", "yes", NA, "yes", "no", "yes"), 
     c("no", "yes", "no", "yes", "yes", "no", "yes", NA),
     c("yes", "yes", "no", "yes", "no", "no", "no", "yes"))
colnames(dt.ex1) <- c("Temp", "Headache", "Nausea", "Flu")
decision.table <- SF.asDecisionTable(dataset = dt.ex1, decision.attr = 4, 
                                    indx.nominal = c(2:4))
indx = MV.globalClosestFit(decision.table)
}
\references{
J. Grzymala-Busse and W. Grzymala-Busse, "Handling Missing Attribute Values," in Data Mining and Knowledge Discovery Handbook, 
O. Maimon and L. Rokach, Eds. New York : Springer, 2010, pp. 33-51
}
\seealso{
\code{\link{MV.missingValueCompletion}}
}
\author{
Lala Septem Riza
}
