% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Discretization.R
\name{D.local.discernibility.heuristic.RST}
\alias{D.local.discernibility.heuristic.RST}
\title{Supervised discretization based on the local discernibility heuristic}
\usage{
D.local.discernibility.heuristic.RST(decision.table, maxNOfCuts = 2,
  cutCandidatesList = NULL, discFunction = local.discernibility)
}
\arguments{
\item{decision.table}{an object inheriting from the \code{"DecisionTable"} class, which represents a decision system.
See \code{\link{SF.asDecisionTable}}.
It should be noted that for this particular method all conditional attributes
must be numeric.}

\item{maxNOfCuts}{a positive integer indicating the maximum number of allowed cuts on a single attribute.}

\item{cutCandidatesList}{an optional list containing candidates for optimal cut values.
By default the candidating cuts are determined automatically.}

\item{discFunction}{a function used for computation of cuts. Currently only one implementation of the local discernibility heuristic
is available (the default). However, this parameter can be used to integrate custom implementations of
discretization functions with the \code{RoughSets} package.}
}
\value{
An object of a class \code{"Discretization"} which stores cuts for each conditional attribute.
        See \code{\link{D.discretization.RST}}.
}
\description{
It is a function used for computing locally semi-optimal cuts using the local discernibility heuristic.
}
\details{
A local (univariate) version of the algorithm described in (Nguyen, 2001) and (Bazan et al., 2000).

The output of this function is an object of a class \code{"Discretization"}
which contains cut values.
The function \code{\link{SF.applyDecTable}} has to be used in order to generate the new (discretized) decision table.
}
\examples{
#################################################################
## Example: Determine cut values and generate new decision table
#################################################################
data(RoughSetData)
wine.data <- RoughSetData$wine.dt
cut.values <- D.local.discernibility.heuristic.RST(wine.data)

## generate a new decision table:
wine.discretized <- SF.applyDecTable(wine.data, cut.values)
dim(wine.discretized)
lapply(wine.discretized, unique)

}
\references{
S. H. Nguyen, "On Efficient Handling of Continuous Attributes in Large Data Bases",
Fundamenta Informaticae, vol. 48, p. 61 - 81 (2001).

Jan G. Bazan, Hung Son Nguyen, Sinh Hoa Nguyen, Piotr Synak, and Jakub Wroblewski,
"Rough Set Algorithms in Classification Problem", Chapter 2
In: L. Polkowski, S. Tsumoto and T.Y. Lin (eds.): Rough Set Methods and Applications
Physica-Verlag, Heidelberg, New York, p. 49 - 88 ( 2000).
}
\seealso{
\code{\link{D.discretize.quantiles.RST}}, \code{\link{D.discretize.equal.intervals.RST}},
         \code{\link{D.global.discernibility.heuristic.RST}} and \code{\link{SF.applyDecTable}}.
         A wrapper function for all available discretization methods: \code{\link{D.discretization.RST}}
}
\author{
Andrzej Janusz
}
